﻿using System;

namespace RecruitmentTesting.Api.Models
{
    /// <summary>
    /// Represents the candidate on the test. If user has sent two invitations to the same email, each invitation will be mapped to a different candidate.
    /// </summary>
    public class Candidate
    {
        /// <summary>
        /// Gets the id of the candidate.
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// Gets the candidate's email.
        /// </summary>
        public string Email { get; set; }

        /// <summary>
        /// If candidate has started solving the test, gets the candidate's full name.
        /// </summary>
        public string FullName { get; set; }

        /// <summary>
        /// Gets the date when the test invitation will expire.
        /// </summary>
        public DateTime InvitationEndDate { get; set; }

        /// <summary>
        /// Gets the date when the candidate was invited to the test.
        /// </summary>
        public DateTime InvitationDate { get; set; }

        /// <summary>
        /// If the invitation was canceled, gets the date when the cancellation was executed.
        /// </summary>
        public DateTime? CanceledDate { get; set; }

        /// <summary>
        /// Gets the note that the user has entered for the candidate.
        /// </summary>
        public virtual string Note { get; set; }

        /// <summary>
        /// If the candidate has finished solving the test, gets the test score for this candidate on this test.
        /// </summary>
        public int? TestScore { get; set; }

        /// <summary>
        /// Gets the current status for the candidate on the test. 
        /// </summary>
        public CandidateStatus Status { get; set; }

        /// <summary>
        /// If the candidate has finished solving the test, gets the URL for his report.
        /// </summary>
        public string ReportUrl { get; set; }
    }
}
