﻿namespace RecruitmentTesting.Api.Models
{
    /// <summary>
    /// Contains the current status for the candidate on the test.
    /// </summary>
    public enum CandidateStatus
    {
        /// <summary>
        /// Candidate is invited to the test but has not started solving the test.
        /// </summary>
        Invited,
        /// <summary>
        /// Candidate is solving the test.
        /// </summary>
        Started,
        /// <summary>
        /// Candidate has completed the test.
        /// </summary>
        Completed,
        /// <summary>
        /// Candidate did not take the test, that is, he did not start solving the test and the invitation expired.
        /// </summary>
        DidNotTake,
        /// <summary>
        /// The invitation to the test was canceled.
        /// </summary>
        Canceled
    }
}
