﻿using System.ComponentModel.DataAnnotations;

namespace RecruitmentTesting.Api.Models
{
    /// <summary>
    /// Represents arguments needed for defining candidate invitations, such as the targeted test and the candidate's email.
    /// </summary>
    public class InviteCandidateViaUrlArgs
    {
        /// <summary>
        /// Gets or sets the id of the test to which we want to invite candidate.
        /// </summary>
        public int TestId { get; set; }

        /// <summary>
        /// Gets or sets the email of the candidate we want to invite to the specified test.
        /// </summary>
        [MaxLength(100, ErrorMessage = "Max size of email is 100.")]
        public string CandidateEmail { get; set; }

        /// <summary>
        /// Gets or sets the full name of the candidate we want to invite to the specified test. This argument is optional.
        /// </summary>
        [MaxLength(100, ErrorMessage = "Max size of full name is 100.")]
        public string CandidateFullName { get; set; }
    }
}
