$(function () {
  var testId;

  function signIn(email, apiPassword) {
    var loginData = {
      grant_type: 'password',
      username: email,
      password: apiPassword
    };

    $.ajax({
      type: 'POST',
      url: 'https://testdome.com/api/v1/token',
      data: loginData
    }).done(function (data) {
      // Cache the access token in session storage.
      sessionStorage.setItem("TestDomeApiAccessToken", data.access_token);
      enableGettingTests();
    }).fail(showError);
  }

  function enableGettingTests() {
    $("#signInDiv").hide();
    $("#getTestsDiv").show();
  }

  function getTests() {
    var token = sessionStorage.getItem("TestDomeApiAccessToken");
    var headers = {};
    headers.Authorization = 'Bearer ' + token;
    
    $.ajax({
      type: 'GET',
      url: 'https://testdome.com/api/v1/tests',
      headers: headers
    }).done(function (data) {
      displayTests(data);
    }).fail(showError);
  }

  function displayTests(data) {
    $("#getTestsDiv").hide();
    $("#listTestsDiv").show();

    $.each(data, function (index, test) {
      $("#listTestsUl").append("<li>Id: " + test.Id + ", Name: " + test.Name + "</li");
    });
  }

  function getCandidates() {
    testId = $("#testTbx").val().trim();

    var token = sessionStorage.getItem("TestDomeApiAccessToken");
    var headers = {};
    headers.Authorization = 'Bearer ' + token;
        
    $.ajax({
      type: 'GET',
      url: 'https://testdome.com/api/v1/candidates?testId=' + testId,
      headers: headers
    }).done(function (data) {
      displayCandidates(data);
    }).fail(showError);
  }

  function displayCandidates(data) {
    $("#listTestsDiv").hide();
    $("#listCandidatesDiv").show();

    $.each(data, function (index, candidate) {
      $("#listCandidatesUl").append("<li>Id: " + candidate.Id + ", Email: " + candidate.Email + ", Report: " + candidate.ReportUrl + "</li");
    });
  }

  function inviteCandidates() {
    var candidatesStr = $("#inviteCandidatesTbx").val().trim();
    var candidates = candidatesStr.replace(";", ",").split(",");

    var token = sessionStorage.getItem("TestDomeApiAccessToken");
    var headers = {};
    headers.Authorization = 'Bearer ' + token;

    var data = {};
    data.TestId = testId;
    data.CandidateEmails = candidates;

    $.ajax({
      type: 'POST',
      url: 'https://testdome.com/api/v1/candidates/invitecandidates',
      headers: headers,
      data: data
    }).done(function (data) {
      displayInvitedCandidates(data);
    }).fail(showError);
  }

  function displayInvitedCandidates(data) {
    $("#listCandidatesDiv").hide();
    $("#listInvitedCandiatesDiv").show();

    $.each(data.Successful, function (index, candidate) {
      $("#listSuccessfulInvitationsUl").append("<li>" + candidate + "</li");
    });

    $.each(data.Unsuccessful, function (index, candidate) {
      $("#listUnsuccessfulInvitationsUl").append("<li>" + candidate + "</li");
    });
  }

  function showError(jqXHR, textStatus) {
    alert("Request failed: " + textStatus);
  }

  $("#signInBtn").click(function () {
	$('#note').hide();
    var email = $("#emailTbx").val().trim();
    var apiPassword = $("#apiPasswordTbx").val().trim();
    signIn(email, apiPassword);
  });

  $("#getTestsBtn").click(getTests);

  $("#getCandidatesBtn").click(getCandidates);

  $("#inviteCandidatesBtn").click(inviteCandidates);

  $("#getTestsDiv, #listTestsDiv, #listCandidatesDiv, #listInvitedCandiatesDiv").hide();
});